/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { i18n, setupI18n } from "@gnu-taler/taler-util";
import * as tests from "../../tests/hook.js";
import { DefaultForm } from "../forms-ui.js";
import { design_VQF_902_1_customer } from "./VQF_902_1_customer.js";

setupI18n("en", {});
type TargetObject = {};
const initial: TargetObject = {};

export const EmptyForm = tests.createExample(DefaultForm, {
  initial,
  design: design_VQF_902_1_customer(i18n),
});

export default { title: "vqf_902_1_customer" };

export const DisabledForm = tests.createExample(DefaultForm, {
  disabled: true,
  initial: {
    "CORRESPONDENCE_LANGUAGE": "en",
    "CUSTOMER_TYPE": "NATURAL_PERSON",
    "CUSTOMER_TYPE_VQF": "NATURAL_PERSON",
    "DATE_OF_BIRTH": "1980-01-09",
    "DOMICILE_ADDRESS": "asd",
    "FORM_ID": "vqf_902_1_customer",
    "FORM_VERSION": 1,
    "FULL_NAME": "asd",
    "NATIONALITY": "AR",
    "PERSONAL_IDENTIFICATION_DOCUMENT_COPY": {
      "CONTENTS": "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa=",
      "ENCODING": "base64",
      "FILENAME": "Glosario-Pagos-Minoristas.pdf",
      "MIME_TYPE": "application/pdf"
    }
  },
  design: design_VQF_902_1_customer(i18n),
});
