# Icelandic (is) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                           | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | --------------------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                                     | Invalid Date             |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                                        | Invalid Date             |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                                     | Invalid Date             |
|                                 |              | 0005-01-01T12:13:14.015Z | 4.                                                        | Invalid Date             |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                        | Invalid Date             |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1F                                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2F                                                        | Invalid Date             |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1. fjórðungur                                             | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. fjórðungur                                             | Invalid Date             |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                                         | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                                         | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                                        | Invalid Date             |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1F                                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2F                                                        | Invalid Date             |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1. fjórðungur                                             | Invalid Date             |
|                                 |              | 2019-04-01T12:13:14.015Z | 2. fjórðungur                                             | Invalid Date             |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2.                                                        | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                        | Invalid Date             |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | feb.                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | júlí                                                      | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | febrúar                                                   | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | júlí                                                      | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | F                                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                         | 2019-01-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2.                                                        | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                                        | Invalid Date             |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | feb.                                                      | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | júlí                                                      | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | febrúar                                                   | Invalid Date             |
|                                 |              | 2019-07-10T12:13:14.015Z | júlí                                                      | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | F                                                         | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | J                                                         | 2019-01-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                       | Invalid Date             |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                                       | Invalid Date             |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11.                                                       | Invalid Date             |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                                       | Invalid Date             |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                                       | Invalid Date             |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                                      | Invalid Date             |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | mán.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fös.                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | mán.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fös.                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | mán.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fös.                                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | mánudagur                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | föstudagur                                                | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | M                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                         | 2019-02-14T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Má                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Fö                                                        | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                        | Invalid Date             |
|                                 | iii          | 2019-02-11T12:13:14.015Z | mán.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fös.                                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | mánudagur                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | föstudagur                                                | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | M                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                         | 2019-02-14T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Má                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Fö                                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                        | Invalid Date             |
|                                 | eee          | 2019-02-11T12:13:14.015Z | mán.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fös.                                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | mánudagur                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | föstudagur                                                | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | M                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                         | 2019-02-14T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Má                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Fö                                                        | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                                        | Invalid Date             |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | mán.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | fös.                                                      | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | mánudagur                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | föstudagur                                                | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | M                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | F                                                         | 2019-02-14T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Má                                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Fö                                                        | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | fyrir hádegi                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | eftir hádegi                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | eftir hádegi                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fyrir hádegi                                              | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | f                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f                                                         | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e.h.                                                      | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f.h.                                                      | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | fyrir hádegi                                              | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | eftir hádegi                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | eftir hádegi                                              | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | fyrir hádegi                                              | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | f                                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | e                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | e                                                         | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | f                                                         | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | að morgni                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | síðdegis                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | um kvöld                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | um nótt                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | að morgni                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | síðdegis                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | um kvöld                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | um nótt                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | að morgni                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | síðdegis                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | um kvöld                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | um nótt                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | að morgni                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | síðdegis                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | um kvöld                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | um nótt                                                   | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | að morgni                                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | síðdegis                                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | um kvöld                                                  | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | um nótt                                                   | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                                       | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                       | Invalid Date             |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                                       | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                       | Invalid Date             |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                                       | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                                       | Invalid Date             |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                                       | Invalid Date             |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                                       | Invalid Date             |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                                       | Invalid Date             |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                                        | Invalid Date             |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                                       | Invalid Date             |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                                | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11. feb. 1987                                             | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maí 1453                                              | Invalid Date             |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11. febrúar 1987                                          | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maí 1453                                              | Invalid Date             |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | miðvikudagur, 11. febrúar 1987                            | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | sunnudagur, 29. maí 1453                                  | Invalid Date             |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                                     | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                                     | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                                  | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                                  | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                            | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | kl. 12:13:14 GMT+00:00                                    | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | kl. 23:59:59 GMT+00:00                                    | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987 12:13                                          | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453 23:59                                          | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11. feb. 1987 12:13:14                                    | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maí 1453 23:59:59                                     | Invalid Date             |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11. febrúar 1987 kl. 12:13:14 GMT+0                       | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | 29. maí 1453 kl. 23:59:59 GMT+0                           | Invalid Date             |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | miðvikudagur, 11. febrúar 1987 kl. kl. 12:13:14 GMT+00:00 | Invalid Date             |
|                                 |              | 1453-05-29T23:59:59.999Z | sunnudagur, 29. maí 1453 kl. kl. 23:59:59 GMT+00:00       | Invalid Date             |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result                 | `includeSeconds: true` | `addSuffix: true`            |
| ------------------------ | ---------------------- | ---------------------- | ---------------------------- |
| 2006-01-01T00:00:00.000Z | u.þ.b. 6 ár            | u.þ.b. 6 ár            | í u.þ.b. 6 ár                |
| 2005-01-01T00:00:00.000Z | u.þ.b. 5 ár            | u.þ.b. 5 ár            | í u.þ.b. 5 ár                |
| 2004-01-01T00:00:00.000Z | u.þ.b. 4 ár            | u.þ.b. 4 ár            | í u.þ.b. 4 ár                |
| 2003-01-01T00:00:00.000Z | u.þ.b. 3 ár            | u.þ.b. 3 ár            | í u.þ.b. 3 ár                |
| 2002-01-01T00:00:00.000Z | u.þ.b. 2 ár            | u.þ.b. 2 ár            | í u.þ.b. 2 ár                |
| 2001-06-01T00:00:00.000Z | meira en 1 ár          | meira en 1 ár          | í meira en 1 ár              |
| 2001-02-01T00:00:00.000Z | u.þ.b. 1 ár            | u.þ.b. 1 ár            | í u.þ.b. 1 ár                |
| 2001-01-01T00:00:00.000Z | u.þ.b. 1 ár            | u.þ.b. 1 ár            | í u.þ.b. 1 ár                |
| 2000-06-01T00:00:00.000Z | 5 mánuðir              | 5 mánuðir              | í 5 mánuðir                  |
| 2000-03-01T00:00:00.000Z | 2 mánuðir              | 2 mánuðir              | í 2 mánuðir                  |
| 2000-02-01T00:00:00.000Z | u.þ.b. 1 mánuður       | u.þ.b. 1 mánuður       | í u.þ.b. 1 mánuður           |
| 2000-01-15T00:00:00.000Z | 14 dagar               | 14 dagar               | í 14 dagar                   |
| 2000-01-02T00:00:00.000Z | 1 dagur                | 1 dagur                | í 1 dagur                    |
| 2000-01-01T06:00:00.000Z | u.þ.b. 6 klukkustundir | u.þ.b. 6 klukkustundir | í u.þ.b. 6 klukkustundir     |
| 2000-01-01T01:00:00.000Z | u.þ.b. 1 klukkustund   | u.þ.b. 1 klukkustund   | í u.þ.b. 1 klukkustund       |
| 2000-01-01T00:45:00.000Z | u.þ.b. 1 klukkustund   | u.þ.b. 1 klukkustund   | í u.þ.b. 1 klukkustund       |
| 2000-01-01T00:30:00.000Z | 30 mínútur             | 30 mínútur             | í 30 mínútur                 |
| 2000-01-01T00:15:00.000Z | 15 mínútur             | 15 mínútur             | í 15 mínútur                 |
| 2000-01-01T00:01:00.000Z | 1 mínúta               | 1 mínúta               | í 1 mínúta                   |
| 2000-01-01T00:00:25.000Z | minna en 1 mínúta      | hálf mínúta            | í minna en 1 mínúta          |
| 2000-01-01T00:00:15.000Z | minna en 1 mínúta      | minna en 20 sekúndur   | í minna en 1 mínúta          |
| 2000-01-01T00:00:05.000Z | minna en 1 mínúta      | minna en 10 sekúndur   | í minna en 1 mínúta          |
| 2000-01-01T00:00:00.000Z | minna en 1 mínúta      | minna en 5 sekúndur    | minna en 1 mínúta síðan      |
| 1999-12-31T23:59:55.000Z | minna en 1 mínúta      | minna en 10 sekúndur   | minna en 1 mínúta síðan      |
| 1999-12-31T23:59:45.000Z | minna en 1 mínúta      | minna en 20 sekúndur   | minna en 1 mínúta síðan      |
| 1999-12-31T23:59:35.000Z | minna en 1 mínúta      | hálf mínúta            | minna en 1 mínúta síðan      |
| 1999-12-31T23:59:00.000Z | 1 mínúta               | 1 mínúta               | 1 mínúta síðan               |
| 1999-12-31T23:45:00.000Z | 15 mínútur             | 15 mínútur             | 15 mínútur síðan             |
| 1999-12-31T23:30:00.000Z | 30 mínútur             | 30 mínútur             | 30 mínútur síðan             |
| 1999-12-31T23:15:00.000Z | u.þ.b. 1 klukkustund   | u.þ.b. 1 klukkustund   | u.þ.b. 1 klukkustund síðan   |
| 1999-12-31T23:00:00.000Z | u.þ.b. 1 klukkustund   | u.þ.b. 1 klukkustund   | u.þ.b. 1 klukkustund síðan   |
| 1999-12-31T18:00:00.000Z | u.þ.b. 6 klukkustundir | u.þ.b. 6 klukkustundir | u.þ.b. 6 klukkustundir síðan |
| 1999-12-30T00:00:00.000Z | 2 dagar                | 2 dagar                | 2 dagar síðan                |
| 1999-12-15T00:00:00.000Z | 17 dagar               | 17 dagar               | 17 dagar síðan               |
| 1999-12-01T00:00:00.000Z | u.þ.b. 1 mánuður       | u.þ.b. 1 mánuður       | u.þ.b. 1 mánuður síðan       |
| 1999-11-01T00:00:00.000Z | 2 mánuðir              | 2 mánuðir              | 2 mánuðir síðan              |
| 1999-06-01T00:00:00.000Z | 7 mánuðir              | 7 mánuðir              | 7 mánuðir síðan              |
| 1999-01-01T00:00:00.000Z | u.þ.b. 1 ár            | u.þ.b. 1 ár            | u.þ.b. 1 ár síðan            |
| 1998-12-01T00:00:00.000Z | u.þ.b. 1 ár            | u.þ.b. 1 ár            | u.þ.b. 1 ár síðan            |
| 1998-06-01T00:00:00.000Z | meira en 1 ár          | meira en 1 ár          | meira en 1 ár síðan          |
| 1998-01-01T00:00:00.000Z | u.þ.b. 2 ár            | u.þ.b. 2 ár            | u.þ.b. 2 ár síðan            |
| 1997-01-01T00:00:00.000Z | u.þ.b. 3 ár            | u.þ.b. 3 ár            | u.þ.b. 3 ár síðan            |
| 1996-01-01T00:00:00.000Z | u.þ.b. 4 ár            | u.þ.b. 4 ár            | u.þ.b. 4 ár síðan            |
| 1995-01-01T00:00:00.000Z | u.þ.b. 5 ár            | u.þ.b. 5 ár            | u.þ.b. 5 ár síðan            |
| 1994-01-01T00:00:00.000Z | u.þ.b. 6 ár            | u.þ.b. 6 ár            | u.þ.b. 6 ár síðan            |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result          | `addSuffix: true`     | With forced unit (i.e. `hour`) |
| ------------------------ | --------------- | --------------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 ár            | í 6 ár                | 52608 klukkustundir            |
| 2005-01-01T00:00:00.000Z | 5 ár            | í 5 ár                | 43848 klukkustundir            |
| 2004-01-01T00:00:00.000Z | 4 ár            | í 4 ár                | 35064 klukkustundir            |
| 2003-01-01T00:00:00.000Z | 3 ár            | í 3 ár                | 26304 klukkustundir            |
| 2002-01-01T00:00:00.000Z | 2 ár            | í 2 ár                | 17544 klukkustundir            |
| 2001-06-01T00:00:00.000Z | 1 ár            | í 1 ár                | 12408 klukkustundir            |
| 2001-02-01T00:00:00.000Z | 1 ár            | í 1 ár                | 9528 klukkustundir             |
| 2001-01-01T00:00:00.000Z | 1 ár            | í 1 ár                | 8784 klukkustundir             |
| 2000-06-01T00:00:00.000Z | 5 mánuðir       | í 5 mánuðir           | 3648 klukkustundir             |
| 2000-03-01T00:00:00.000Z | 2 mánuðir       | í 2 mánuðir           | 1440 klukkustundir             |
| 2000-02-01T00:00:00.000Z | 1 mánuður       | í 1 mánuður           | 744 klukkustundir              |
| 2000-01-15T00:00:00.000Z | 14 dagar        | í 14 dagar            | 336 klukkustundir              |
| 2000-01-02T00:00:00.000Z | 1 dagur         | í 1 dagur             | 24 klukkustundir               |
| 2000-01-01T06:00:00.000Z | 6 klukkustundir | í 6 klukkustundir     | 6 klukkustundir                |
| 2000-01-01T01:00:00.000Z | 1 klukkustund   | í 1 klukkustund       | 1 klukkustund                  |
| 2000-01-01T00:45:00.000Z | 45 mínútur      | í 45 mínútur          | 1 klukkustund                  |
| 2000-01-01T00:30:00.000Z | 30 mínútur      | í 30 mínútur          | 1 klukkustund                  |
| 2000-01-01T00:15:00.000Z | 15 mínútur      | í 15 mínútur          | 0 klukkustundir                |
| 2000-01-01T00:01:00.000Z | 1 mínúta        | í 1 mínúta            | 0 klukkustundir                |
| 2000-01-01T00:00:25.000Z | 25 sekúndur     | í 25 sekúndur         | 0 klukkustundir                |
| 2000-01-01T00:00:15.000Z | 15 sekúndur     | í 15 sekúndur         | 0 klukkustundir                |
| 2000-01-01T00:00:05.000Z | 5 sekúndur      | í 5 sekúndur          | 0 klukkustundir                |
| 2000-01-01T00:00:00.000Z | 0 sekúndur      | 0 sekúndur síðan      | 0 klukkustundir                |
| 1999-12-31T23:59:55.000Z | 5 sekúndur      | 5 sekúndur síðan      | 0 klukkustundir                |
| 1999-12-31T23:59:45.000Z | 15 sekúndur     | 15 sekúndur síðan     | 0 klukkustundir                |
| 1999-12-31T23:59:35.000Z | 25 sekúndur     | 25 sekúndur síðan     | 0 klukkustundir                |
| 1999-12-31T23:59:00.000Z | 1 mínúta        | 1 mínúta síðan        | 0 klukkustundir                |
| 1999-12-31T23:45:00.000Z | 15 mínútur      | 15 mínútur síðan      | 0 klukkustundir                |
| 1999-12-31T23:30:00.000Z | 30 mínútur      | 30 mínútur síðan      | 1 klukkustund                  |
| 1999-12-31T23:15:00.000Z | 45 mínútur      | 45 mínútur síðan      | 1 klukkustund                  |
| 1999-12-31T23:00:00.000Z | 1 klukkustund   | 1 klukkustund síðan   | 1 klukkustund                  |
| 1999-12-31T18:00:00.000Z | 6 klukkustundir | 6 klukkustundir síðan | 6 klukkustundir                |
| 1999-12-30T00:00:00.000Z | 2 dagar         | 2 dagar síðan         | 48 klukkustundir               |
| 1999-12-15T00:00:00.000Z | 17 dagar        | 17 dagar síðan        | 408 klukkustundir              |
| 1999-12-01T00:00:00.000Z | 1 mánuður       | 1 mánuður síðan       | 744 klukkustundir              |
| 1999-11-01T00:00:00.000Z | 2 mánuðir       | 2 mánuðir síðan       | 1464 klukkustundir             |
| 1999-06-01T00:00:00.000Z | 7 mánuðir       | 7 mánuðir síðan       | 5136 klukkustundir             |
| 1999-01-01T00:00:00.000Z | 1 ár            | 1 ár síðan            | 8760 klukkustundir             |
| 1998-12-01T00:00:00.000Z | 1 ár            | 1 ár síðan            | 9504 klukkustundir             |
| 1998-06-01T00:00:00.000Z | 2 ár            | 2 ár síðan            | 13896 klukkustundir            |
| 1998-01-01T00:00:00.000Z | 2 ár            | 2 ár síðan            | 17520 klukkustundir            |
| 1997-01-01T00:00:00.000Z | 3 ár            | 3 ár síðan            | 26280 klukkustundir            |
| 1996-01-01T00:00:00.000Z | 4 ár            | 4 ár síðan            | 35064 klukkustundir            |
| 1995-01-01T00:00:00.000Z | 5 ár            | 5 ár síðan            | 43824 klukkustundir            |
| 1994-01-01T00:00:00.000Z | 6 ár            | 6 ár síðan            | 52584 klukkustundir            |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                 |
| ------------------------ | ---------------------- |
| 2000-01-10T00:00:00.000Z | 1                      |
| 2000-01-05T00:00:00.000Z | 0005 kl. 00:00         |
| 2000-01-02T00:00:00.000Z | á morgun kl. 00:00     |
| 2000-01-01T00:00:00.000Z | í dag kl. 00:00        |
| 1999-12-31T00:00:00.000Z | í gær kl. 00:00        |
| 1999-12-27T00:00:00.000Z | síðasta 0027 kl. 00:00 |
| 1999-12-21T00:00:00.000Z | 12                     |
